/**
 *
 * Version : $Id$
 * This file was generated by Aldebaran Robotics ModuleGenerator
 */

#include "events.h"

#include <alvalue/alvalue.h>
#include <alcommon/alproxy.h>
#include <alcommon/albroker.h>

#include <qi/log.hpp>


Events::Events(
  boost::shared_ptr<AL::ALBroker> broker,
  const std::string& name):
      AL::ALModule(broker, name),
      fMemoryProxy(getParentBroker())
{
  setModuleDescription("");


  functionName("callback", getName(), "");
  BIND_METHOD(Events::callback);

}

Events::~Events() {
  fMemoryProxy.unsubscribeToEvent("ExampleEvent", "Events");
  fMemoryProxy.unsubscribeToMicroEvent("ExampleMicroEvent", "Events");
}

void Events::init() {
  try {
    //Allow ALMemory to start the Events module when someone subscribe to ExampleEvent
    //This module should inherit from ALExtractor
    //It's not necessary to call this function when you dont want the autostart feature.
    //fMemoryProxy.declareEvent("ExampleEvent", "Events");

    fMemoryProxy.subscribeToEvent("ExampleEvent", "Events", "userDataToIdentifyEvent", "callback");
    fMemoryProxy.subscribeToMicroEvent("ExampleMicroEvent", "Events", "AnotherUserDataToIdentifyEvent", "callback");

    //generate a simple event for the test
    generateEvent(42.0);
    generateMicroEvent(42.0);
  }
  catch (const AL::ALError& e) {
    qiLogError("module.example") << e.what() << std::endl;
  }

}

void Events::generateEvent(const float& value) {
  /** Raise an event with its value (here a float, but could be something else.*/
  fMemoryProxy.raiseEvent("ExampleEvent", value);
}

void Events::generateMicroEvent(const float& value) {
  /** Raise an event with its value (here a float, but could be something else.*/
  fMemoryProxy.raiseMicroEvent("ExampleMicroEvent", value);
}

void Events::callback(const std::string &key, const AL::ALValue &value, const AL::ALValue &msg) {
  qiLogInfo("module.example") << "Callback:" << key << std::endl;
  qiLogInfo("module.example") << "Value   :" << value << std::endl;
  qiLogInfo("module.example") << "Msg     :" << msg << std::endl;
}
